#include "fitness.h"

namespace lp {


	int optimistic_estimate(
		const Functor& bottom,
		const io_map& iovars)
	{
		// cerr << "computing optimistic_estimate...\n";
		// Grab all variable depths
		const auto depthm = var_depth(bottom,iovars);
		// cerr << "var_depth done\n";
		//DEBUG_TRACE(
			// cerr << "Variable Depths for " << bottom << ":\n";
			//for (auto i = depthm.begin(); i != depthm.end(); ++i) {
			//	cerr << fmap.get_data(i->first) << " -> " << i->second << "\n";
			//}
		//);
		// Compute min depth of +types in head
		const set<id_type>& head_ivars = iovars[0].first;
		int opt = numeric_limits<int>::max();
		for_each(head_ivars.begin(),head_ivars.end(),[&](const id_type i){
			auto at = depthm.find(i);
			if (at != depthm.end() && at->second < opt) opt = at->second;
		});
		DEBUG_TRACE( cerr << "Optimistic Estimate: " << opt << "\n");
		return opt;
	}


	std::map<id_type,int> var_depth(const Functor& f, const io_map& iov)
	{
		//DEBUG_TRACE(cerr << "Computing variable depths for " << f << "\n");
		std::map<id_type,int> depthm;
		// Pathological case: if there are no output types in head, all variables get 0
		if (iov[0].second.empty()) {
			// Set all variable depths to 0
			for (auto& n : f) if (n.is_variable()) depthm[n.id()] = 0;
			return depthm;
		}

		// Instantiate depth iteratively
		// output variables in head have depth 0
		set<id_type> pvars;
		const set<id_type>& head_outputs = iov[0].second;
		for_each(head_outputs.begin(),head_outputs.end(),[&](const id_type v){
			//cerr << "  Setting " << fmap.get_data(v) << " -> 0\n";
			depthm[v] = 0;
			pvars.insert(v);
		});
		// Body variable depths
		int depth = 0;
		for (;;) {
			// While an iteration creates new variable depths
			set<id_type> new_vars;
			int k = 1;
			for (auto bl = f.body_begin(); bl != f.body_end(); ++bl,++k) {
				const set<id_type>& outvars = iov[k].second;
				// Do we have an input type that is in pvars?
				set<id_type> common;
				set_intersection(outvars.begin(),outvars.end(),pvars.begin(),pvars.end(),inserter(common,common.begin()));
				if (common.empty()) continue; // ignore this literal
				// Compute min d({all input types of depth})
				const set<id_type>& invars = iov[k].first;
				for_each(invars.begin(),invars.end(),[&](const id_type i){ 
					auto p = depthm.insert(make_pair(i,depth+1)); // doesn't overwrite older (lower) values
					if (p.second) {
						assert(depthm[i] == depth+1);
						// cerr << "  Setting " << fmap.get_data(i) << " -> " << depth+1 << "\n";
						new_vars.insert(i); // new variable if insertion succeeded
					}
				});
			}
			if (new_vars.empty()) break; // no more iterations needed
			// Update
			pvars = move(new_vars);
			++depth;
		}
		return depthm;
	}



}

